// Glenn's POV-Ray Ruler Include File
// created 20-June-96; last update 29-Sep-97
//
// Copyright 2005 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License. 
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/ 

// Creates a visible X-Y-Z coordinate system,
// for scenes with objects a few units to
// hundreds of units in size.
// Just #include this file to display the ruler.

#declare RulerCube =
   box {
     <-.5,-.5,-.5>, <.5,.5,.5>
     texture { finish { ambient .9 } }
   }

#declare XRuler = //Yellow
   union {
     object { RulerCube pigment { color <1,1,0> } translate <2,0,0> }
     object { RulerCube pigment { color <1,1,0> } translate <4,0,0> }
     object { RulerCube pigment { color <1,1,0> } translate <6,0,0> }
     object { RulerCube pigment { color <1,1,0> } translate <8,0,0> }
     object { RulerCube pigment { color <1,1,0> } translate <10,0,0> }
     object { RulerCube pigment { color <1,1,0> } scale <100,2,2> translate <62,0,0> }
     object { RulerCube pigment { color <1,1,0> } scale <1000,5,5> translate <562,0,0> }
    }
#declare YRuler = //Blue
   union {
     object { RulerCube pigment {color <0,0,1> } translate <2,0,0> }
     object { RulerCube pigment {color <0,0,1> } translate <4,0,0> }
     object { RulerCube pigment {color <0,0,1> } translate <6,0,0> }
     object { RulerCube pigment {color <0,0,1> } translate <8,0,0> }
     object { RulerCube pigment {color <0,0,1> } translate <10,0,0> }
     object { RulerCube pigment {color <0,0,1> } scale <100,2,2> translate <62,0,0> }
     object { RulerCube pigment {color <0,0,1> } scale <1000,5,5> translate <562,0,0> }
    }
#declare ZRuler = //Red
   union {
     object { RulerCube pigment {color <1,0,0> } translate <2,0,0> }
     object { RulerCube pigment {color <1,0,0> } translate <4,0,0> }
     object { RulerCube pigment {color <1,0,0> } translate <6,0,0> }
     object { RulerCube pigment {color <1,0,0> } translate <8,0,0> }
     object { RulerCube pigment {color <1,0,0> } translate <10,0,0> }
     object { RulerCube pigment {color <1,0,0> } scale <100,2,2> translate <62,0,0> }
     object { RulerCube pigment {color <1,0,0> } scale <1000,5,5> translate <562,0,0> }
   }


#declare LabelBackground =
   box {
     <-2,-1.5,-.05>, <2,1.5,.05>
     // no_shadow
     texture {
       pigment { color <1,1,1> }
       finish { ambient .9 }
     }
   }

#declare Xlabel = union {
         object { LabelBackground }
         box {<-1.5,0,-.2> <1.5,.5,.2> rotate z*30}
         box {<-1.5,0,-.2> <1.5,.5,.2> rotate z*-30}
         pigment {color <1,1,0>}
}
#declare Ylabel = union {
         object { LabelBackground }
         box {<-1.5,0,-.2> <0,.5,.2> }
         box {<0,0,-.2> <1.5,.5,.2> rotate z*30}
         box {<0,0,-.2> <1.5,.5,.2> rotate z*-30}
         pigment {color <0,0,1>}
}
#declare Zlabel = union {
         object { LabelBackground }
         box {<-1.5,0,-.2> <1.5,.5,.2> rotate z*-30}
         box {<-1.5,-.75,-.2> <-1,.75,.2> }
         box {<1,-.75,-.2> <1.5,.75,.2> }
         pigment {color <1,0,0>}
}

//object {Zlabel }

#declare GRuler =
	union {
		object { RulerCube pigment {color <1,1,1> } scale .2 } // this is the origin
		object { XRuler rotate <0,0,0>} // X-axis
		object { YRuler rotate <0,0,90>} // Y-axis
		object { ZRuler rotate <0,-90,0>} // Z-axis
		object { Xlabel translate <10,3,0>}
		object { Xlabel rotate y*-90 rotate z*90 translate <10,0,3>}
		object { Ylabel translate <10,-3,0> rotate z*90 }
		object { Ylabel rotate y*-90 translate <0,10,3>}
		object { Zlabel translate <10,-3,0> rotate x*90 rotate y*-90}
		object { Zlabel rotate y*-90 translate <0,3,10>}
	}

object { GRuler }
